#include <zephyr.h>
#include <device.h>
#include <devicetree.h>
#include <drivers/gpio.h>
#include <math.h>

#include "lcd.h"

#define screenWidth 240
#define screenHeight 240

uint16_t rgb(int r, int g, int b)
{
	uint16_t c = (((r) << 11) | ((g) << 5) | (b));

	return ((c >> 8) & 0xFF) | ((c & 0xFF) << 8);
}

void cpu128()
{

	*(volatile uint32_t *)0x5084450C = 0x4040;
	*(volatile uint32_t *)0x50026548 = 0x40;
	*(volatile uint32_t *)0x50081EE4 = 0x4D;
	NRF_CLOCK_S->HFCLKCTRL = 0;
}

void cpu64()
{
	NRF_CLOCK_S->HFCLKCTRL = 1;
	*(volatile uint32_t *)0x5084450C = 0x0;
	*(volatile uint32_t *)0x50026548 = 0x0;
	*(volatile uint32_t *)0x50081EE4 = 0x0D;
}



void main(void)
{
	const struct device *gpio0;
	bool led_is_on = true;

	uint16_t *frame_buffer;

	frame_buffer = lcd_get_buffer();
	
	lcd_configure();

	printk("hello cruel world\n");

	gpio0 = device_get_binding("GPIO_0");

	gpio_pin_configure(gpio0, 28, GPIO_OUTPUT_ACTIVE);
	gpio_pin_configure(gpio0, 23, GPIO_INPUT | GPIO_PULL_UP);
	gpio_pin_configure(gpio0, 24, GPIO_INPUT | GPIO_PULL_UP);
	gpio_pin_configure(gpio0, 8, GPIO_INPUT | GPIO_PULL_UP);
	gpio_pin_configure(gpio0, 9, GPIO_INPUT | GPIO_PULL_UP);

	for(int x = 0; x < screenWidth; x++)
		for(int y = 0; y < screenHeight; y++)
			*frame_buffer++ = rgb((x^y)>>3, ((240-x) ^ y)>>2, (x ^ (240-y))>>3);

	while (1)
	{
		gpio_pin_set(gpio0, 28, (int)led_is_on);
		led_is_on = !led_is_on;
		lcd_update_screen();
	}
}



